<?php
/**
 * API ROUTER - HOLMAN F (FYCLS SAS)
 * Versin Blindada contra errores JSON
 */

// 1. Limpieza de salida previa y configuracin de cabeceras
ob_start();
header('Content-Type: application/json');

require_once __DIR__ . '/config.php';
require_once INC . 'auth.php';
require_once INC . 'reportes.php';
require_once INC . 'ia.php';

$action = $_POST['action'] ?? $_GET['action'] ?? '';

try {
    // ACCIONES P03BLICAS
    if ($action === 'login') {
        $r = auth_login($pdo, $_POST['username'] ?? '', $_POST['password'] ?? '');
        json_ok($r);
    }

    if ($action === 'logout') {
        auth_logout();
        json_ok(['msg' => 'Sesin cerrada']);
    }

    // VERIFICACI07N DE SESI07N
    if (!auth_check()) {
        json_err('Sesin expirada. Por favor, recarga la pgina.');
    }

    // ROUTER CON BREAKS OBLIGATORIOS
    switch ($action) {
        case 'dashboard':
            json_ok(rep_dashboard($pdo, (int)($_POST['mes'] ?? date('n')), (int)($_POST['anio'] ?? date('Y'))));
            break;

        case 'reportes':
            json_ok(rep_list($pdo, $_POST));
            break;

        case 'reporte_save':
            $id = (int)($_POST['id'] ?? 0);
            $newId = rep_save($pdo, $_POST, $id);
            json_ok(['id' => $newId, 'msg' => $id ? 'Actualizado.' : 'Creado.']);
            break;

        case 'contactos_list':
            json_ok($pdo->query("SELECT * FROM st_contactos ORDER BY nombre ASC")->fetchAll());
            break;

        case 'ia':
            json_ok(ia_sugerencias($pdo, $_POST['desc'] ?? '', $_POST['cat'] ?? ''));
            break;

        default:
            json_err("Accin '{$action}' no reconocida.");
            break;
    }

} catch (Exception $e) {
    // Capturamos cualquier fallo y lo enviamos como JSON vlido
    json_err("Falla tcnica en FYCLS: " . $e->getMessage());
}