/* Sistema Soporte Técnico — Holman F — FYCLS SAS Edition */
(function(){
'use strict';

var API = 'api.php'; 

// --- FUNCIÓN POST BLINDADA ---
function post(action, data, cb){
    var fd = new FormData();
    fd.append('action', action);
    // Verificación segura del token CSRF
    fd.append('_csrf', (typeof CSRF !== 'undefined' ? CSRF : ''));
    
    for(var k in data) fd.append(k, data[k] ?? '');
    
    fetch(API, { method: 'POST', body: fd })
        .then(function(response) {
            // Si el servidor falla (404, 500), leemos como texto para depurar
            if (!response.ok) {
                return response.text().then(function(t) { throw new Error(t || 'Error de servidor'); });
            }
            return response.json();
        })
        .then(function(r) {
            if (r.ok) cb(null, r.data);
            else cb(r.msg || 'Error en la operación.', null);
        })
        .catch(function(err) {
            console.error("Falla en API FYCLS:", err);
            cb('Error de comunicación: El servidor envió una respuesta no válida o está caído.', null);
        });
}

// --- LOGIN REPARADO ---
function initLogin() {
    var btnLogin = $('#btn-login');
    if(!btnLogin) return;

    on(btnLogin, 'click', function(){
        var u = $('#u').value.trim(), p = $('#p').value;
        if(!u || !p){ toast('Por favor, ingresa tus credenciales.', 'err'); return; }
        
        btnLogin.disabled = true;
        btnLogin.innerHTML = '<span class="spin"></span> Validando...';

        post('login', {username: u, password: p}, function(err, res){
            if(err){ 
                toast(err, 'err'); 
                btnLogin.disabled = false;
                btnLogin.textContent = 'Ingresar al sistema';
            } else { 
                toast('Acceso concedido. Iniciando sesión...', 'ok');
                // Pequeño retraso para que la sesión se guarde en disco en cPanel
                setTimeout(function(){ location.reload(); }, 500); 
            }
        });
    });
}



// --- INICIALIZACIÓN ---
on(window, 'load', function(){
    initLogin();
    
    if(typeof LOGGED !== 'undefined' && LOGGED){
        // Carga dinámica de Chart.js solo si hay sesión
        var s = document.createElement('script');
        s.src = 'https://cdnjs.cloudflare.com/ajax/libs/Chart.js/4.4.0/chart.umd.min.js';
        s.onload = function(){ show('dashboard'); };
        document.head.appendChild(s);
    }
});

// ... resto de tus funciones (show, toast, esc, etc.) ...
})();