<?php
/**
 * HOLMAN F - CONFIGURACIÓN MAESTRA
 * Empresa: FYCLS SAS
 */

define('DB_HOST', 'localhost');
define('DB_NAME', 'evolucionamos_holman');
define('DB_USER', 'evolucionamos_holman');
define('DB_PASS', 'Toor2025**H');

define('APP_NAME', 'Soporte Técnico FYCLS');
define('SESSION_MINUTES', 30);

define('ROOT', __DIR__);
define('INC',  ROOT . '/includes/');

// Configuración de sesión segura
if (session_status() === PHP_SESSION_NONE) {
    ini_set('session.use_strict_mode', 1);
    ini_set('session.cookie_httponly', 1);
    ini_set('session.gc_maxlifetime', SESSION_MINUTES * 60);
    session_start();
}

// Conexión PDO mejorada
try {
    $pdo = new PDO(
        'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4',
        DB_USER, DB_PASS,
        [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            // Cambio vital: Usamos FETCH_ASSOC para evitar errores de objeto en el login
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC, 
            PDO::ATTR_EMULATE_PREPARES   => false,
        ]
    );
} catch (PDOException $e) {
    die("Error de conexión: " . $e->getMessage());
}

// Helpers JSON con limpieza de búfer para evitar errores de "Unexpected end of JSON"

function json_ok($data = []) {
    if (ob_get_length()) ob_clean(); 
    header('Content-Type: application/json');
    echo json_encode(['ok' => true, 'data' => $data]);
    exit;
}

function json_err($msg = '') {
    if (ob_get_length()) ob_clean();
    header('Content-Type: application/json');
    echo json_encode(['ok' => false, 'msg' => $msg]);
    exit;
}

function csrf_token() {
    if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(24));
    return $_SESSION['csrf'];
}

function csrf_check() {
    if (empty($_SESSION)) return;
    $enviado = $_POST['_csrf'] ?? '';
    $sesion  = $_SESSION['csrf'] ?? '';
    if (empty($enviado) || empty($sesion)) return;
    if (!hash_equals($sesion, $enviado)) {
        $_SESSION['csrf'] = bin2hex(random_bytes(24));
        json_err('Sesión expirada o token inválido.');
    }
}