<?php
/**
 * Motor de Autenticacion - Holman F
 * Cliente: FYCLS SAS
 */

function auth_check() {
    if (!isset($_SESSION['user_id'], $_SESSION['exp'])) return false;
    if (time() > $_SESSION['exp']) { 
        session_destroy(); 
        return false; 
    }
    return true;
}

/**
 * REPARACION CRITICA: 
 * Evita el error de JSON al no usar redirecciones HTML en la API.
 */
function auth_require() {
    if (!auth_check()) { 
        if (isset($_SERVER['HTTP_X_REQUESTED_WITH']) || (isset($_SERVER['PHP_SELF']) && strpos($_SERVER['PHP_SELF'], 'api.php') !== false)) {
            if (ob_get_length()) ob_clean(); 
            header('Content-Type: application/json');
            echo json_encode(['ok' => false, 'msg' => 'Sesion expirada.']);
            exit;
        }
        header('Location: index.php'); 
        exit; 
    }
}

function auth_user() {
    return $_SESSION['user'] ?? null;
}

function is_admin() {
    $user = auth_user();
    $rol = $user['rol'] ?? '';
    return strtolower($rol) === 'admin';
}

function auth_login(PDO $pdo, string $username, string $password): array {
    // Busqueda en st_usuarios para personal de FYCLS SAS
    $st = $pdo->prepare("SELECT * FROM st_usuarios WHERE username=? AND activo=1");
    $st->execute([trim($username)]);
    
    // Forzamos FETCH_ASSOC para evitar conflictos con config.php
    $u = $st->fetch(PDO::FETCH_ASSOC); 
    
    if (!$u) {
        return ['ok' => false, 'msg' => 'Usuario no encontrado.'];
    }
    
    if (!password_verify($password, $u['password'])) {
        return ['ok' => false, 'msg' => 'Contrasena incorrecta.'];
    }
    
    $dur = (defined('SESSION_MINUTES') ? SESSION_MINUTES : 30) * 60;
    
    $_SESSION['user_id'] = $u['id'];
    $_SESSION['exp']     = time() + $dur;
    $_SESSION['user']    = [
        'id'       => $u['id'],
        'username' => $u['username'],
        'nombre'   => $u['nombre'],
        'rol'      => $u['rol']
    ];
    
    return ['ok' => true, 'user' => $_SESSION['user'], 'exp' => $_SESSION['exp']];
}

function auth_logout() { 
    if (session_status() === PHP_SESSION_ACTIVE) {
        session_destroy(); 
    }
}