<?php
/**
 * AIController - Motor Hbrido Interno + Google API
 */

function ai_analyze_action($pdo) {
    auth_require();
    $desc = $_POST['desc'] ?? '';
    $cat  = $_POST['cat'] ?? '';

    if (strlen($desc) < 10) {
        json_err("Describe mejor el problema para que la IA pueda investigar.");
    }

    $internalResults = search_internal_tickets($pdo, $desc);
    $externalResults = search_google_web($desc . " " . $cat);

    json_ok([
        'sugerencias' => [[
            'titulo' => "Anlisis de Incidencia: " . ($cat ?: 'Soporte Tcnico'),
            'pasos' => [
                "Verificar si el error coincide con hallazgos previos.",
                "Aplicar la solucin sugerida por la base de conocimientos externa.",
                "Documentar el resultado para optimizar futuros reportes."
            ],
            'tiempo' => '15-40 min',
            'confianza' => !empty($internalResults) ? 'Alta (Interna)' : 'Media (Web)',
            'categoria' => $cat ?: 'General'
        ]],
        'historial' => $internalResults,
        'fuentes_web' => $externalResults
    ]);
}

function search_google_web($query) {
    $apiKey = "TU_API_KEY_AQUI"; 
    $cx     = "TU_CX_ID_AQUI"; 
    
    $url = "https://www.googleapis.com/customsearch/v1?q=" . urlencode($query) . "&key=$apiKey&cx=$cx&num=3";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 5); 
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); 

    $response = curl_exec($ch);
    curl_close($ch);

    $data = json_decode($response, true);
    $results = [];

    if (isset($data['items'])) {
        foreach ($data['items'] as $item) {
            $results[] = [
                'titulo' => $item['title'],
                'link'   => $item['link'],
                'snippet' => $item['snippet']
            ];
        }
    }
    return $results;
}

function search_internal_tickets($pdo, $desc) {
    $words = explode(' ', $desc);
    $lastWord = end($words);
    
    $st = $pdo->prepare("SELECT id, categoria as cat, descripcion as `desc`, observaciones as sol 
                         FROM tickets WHERE (descripcion LIKE ? OR observaciones LIKE ?) 
                         AND estado = 'Cerrado' LIMIT 2");
    $st->execute(["%$lastWord%", "%$lastWord%"]);
    return $st->fetchAll();
}