<?php
/**
 * AuthController - Motor de Seguridad Holman F
 * Cliente: FYCLS SAS
 */

function auth_login_action($pdo) {
    // 1. Limpieza de datos
    $u = trim($_POST['username'] ?? '');
    $p = $_POST['password'] ?? '';

    if (empty($u) || empty($p)) {
        json_err('Usuario y contraseña son obligatorios.');
    }

    // 2. Ejecución del Login
    // Importante: Asegúrate de que auth.php use la tabla st_usuarios
    $res = auth_login($pdo, $u, $p);

    if (isset($res['ok']) && $res['ok']) {
        // 3. Respuesta estructurada para app.js
        // Accedemos a los datos tratando 'user' como objeto o arreglo según tu PDO
        $user = (array)$res['user']; 
        
        json_ok([
            'nombre' => $user['nombre'],
            'rol'    => $user['rol'],
            'exp'    => $res['exp']
        ]);
    } else {
        // 4. Error detallado para depuración en FYCLS SAS
        json_err($res['msg'] ?? 'Error de autenticación desconocido.');
    }
}

function auth_logout_action() {
    auth_logout(); 
    json_ok(['msg' => 'Sesión de Holman F cerrada correctamente']);
}

function role_require($role_necesario) {
    if (!auth_check()) {
        json_err('Sesión expirada. Por favor, ingresa de nuevo.');
    }

    $user = auth_user();
    // Normalizamos a arreglo para evitar errores de tipo
    $userData = (array)$user;
    if (($userData['rol'] ?? '') !== $role_necesario) {
        json_err("Acceso denegado. Se requiere perfil de: $role_necesario");
    }
}