<?php
/**
 * ReportController - Exportaciones y Reportes Ejecutivos
 */

function report_monthly_action($pdo) {
    auth_require();
    $mes = (int)($_POST['mes'] ?? date('n'));
    $anio = (int)($_POST['anio'] ?? date('Y'));

    // Resumen para la vista de impresión
    $st = $pdo->prepare("SELECT 
        COUNT(*) as total,
        SUM(CASE WHEN estado = 'Cerrado' THEN 1 ELSE 0 END) as cerrados,
        SUM(CASE WHEN observaciones LIKE '%--- Hallazgo IA ---%' THEN 1 ELSE 0 END) as asistidos_ia
    FROM tickets 
    WHERE MONTH(fecha_atencion) = ? AND YEAR(fecha_atencion) = ?");
    
    $st->execute([$mes, $anio]);
    $data = $st->fetch(PDO::FETCH_ASSOC);

    json_ok([
        'periodo' => "$mes/$anio",
        'stats' => $data,
        'msg' => 'Datos de reporte listos'
    ]);
}

function export_excel_action($pdo) {
    auth_require();
    $mes = (int)($_POST['mes'] ?? date('n'));
    $anio = (int)($_POST['anio'] ?? date('Y'));

    // Cabeceras para descarga de archivo
    header('Content-Type: text/csv; charset=utf-8');
    header('Content-Disposition: attachment; filename=Reporte_Holman_'.$mes.'_'.$anio.'.csv');

    $output = fopen('php://output', 'w');
    fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF)); // BOM UTF-8

    fputcsv($output, ['ID', 'Fecha', 'Contacto', 'Categoría', 'Técnico', 'Prioridad', 'Estado', 'Descripción', 'Solución/IA']);

    $st = $pdo->prepare("SELECT id, fecha_atencion, contacto_solicitante, categoria, tecnico_asignado, prioridad, estado, descripcion, observaciones 
                         FROM tickets WHERE MONTH(fecha_atencion) = ? AND YEAR(fecha_atencion) = ?");
    $st->execute([$mes, $anio]);

    while ($row = $st->fetch(PDO::FETCH_ASSOC)) {
        fputcsv($output, $row);
    }
    fclose($output);
    exit;
}