<?php
/**
 * StatsController - Genera los datos para el Dashboard y KPIs
 */

function stats_dashboard_action($pdo) {
    auth_require(); // Garantiza que solo usuarios logueados vean estadísticas
    
    $mes = (int)($_POST['mes'] ?? date('n'));
    $anio = (int)($_POST['anio'] ?? date('Y'));

    // 1. KPIs: Conteo unificado de estados y promedio de satisfacción
    $stKpi = $pdo->prepare("SELECT 
        COUNT(*) as total,
        SUM(CASE WHEN estado = 'Abierto' THEN 1 ELSE 0 END) as abiertos,
        SUM(CASE WHEN estado = 'En proceso' THEN 1 ELSE 0 END) as en_proceso,
        SUM(CASE WHEN estado = 'Cerrado' THEN 1 ELSE 0 END) as cerrados,
        SUM(CASE WHEN prioridad IN ('Alta', 'Crítica', 'Urgente') THEN 1 ELSE 0 END) as alta_prio,
        AVG(NULLIF(satisfaccion, 0)) as avg_sat
    FROM tickets 
    WHERE MONTH(fecha_atencion) = ? AND YEAR(fecha_atencion) = ?");
    
    $stKpi->execute([$mes, $anio]);
    $kpis = $stKpi->fetch();

    // 2. Gráfica de Barras: Reportes diarios
    $stDias = $pdo->prepare("SELECT DAY(fecha_atencion) as dia, COUNT(*) as total 
                             FROM tickets 
                             WHERE MONTH(fecha_atencion) = ? AND YEAR(fecha_atencion) = ? 
                             GROUP BY dia ORDER BY dia ASC");
    $stDias->execute([$mes, $anio]);
    $por_dia = $stDias->fetchAll();

    // 3. Gráfica de Barras: Por Categoría de servicio
    $stCats = $pdo->prepare("SELECT categoria, COUNT(*) as total 
                             FROM tickets 
                             WHERE MONTH(fecha_atencion) = ? AND YEAR(fecha_atencion) = ? 
                             GROUP BY categoria");
    $stCats->execute([$mes, $anio]);
    $por_categoria = $stCats->fetchAll();

    // 4. Gráfica Doughnut: Distribución por Estado
    $stEst = $pdo->prepare("SELECT estado, COUNT(*) as total 
                            FROM tickets 
                            WHERE MONTH(fecha_atencion) = ? AND YEAR(fecha_atencion) = ? 
                            GROUP BY estado");
    $stEst->execute([$mes, $anio]);
    $por_estado = $stEst->fetchAll();

    // 5. Ranking: Top 5 Técnicos con más actividad
    $stTecs = $pdo->prepare("SELECT tecnico_asignado as tecnico, COUNT(*) as total 
                             FROM tickets 
                             WHERE MONTH(fecha_atencion) = ? AND YEAR(fecha_atencion) = ? 
                             GROUP BY tecnico ORDER BY total DESC LIMIT 5");
    $stTecs->execute([$mes, $anio]);
    $por_tecnico = $stTecs->fetchAll();

    // Respuesta estructurada para la función renderCharts() en app.js
    json_ok([
        'total'        => $kpis->total ?? 0,
        'abiertos'     => $kpis->abiertos ?? 0,
        'en_proceso'   => $kpis->en_proceso ?? 0,
        'cerrados'     => $kpis->cerrados ?? 0,
        'alta_prio'    => $kpis->alta_prio ?? 0,
        'satisfaccion' => round($kpis->avg_sat ?? 0, 1),
        'por_dia'      => $por_dia,
        'por_categoria'=> $por_categoria,
        'por_estado'   => $por_estado,
        'por_tecnico'  => $por_tecnico
    ]);
}