<?php
/**
 * TicketController - Gestión de Reportes Holman F
 * Cliente: FYCLS SAS
 */

// Listar reportes con filtros
function ticket_list_action($pdo) {
    auth_require();
    $q = $_POST['q'] ?? '';
    
    $sql = "SELECT id, fecha_atencion, contacto_solicitante as contacto, categoria, 
                   tecnico_asignado as tecnico, prioridad, estado 
            FROM tickets WHERE 1=1";
    $p = [];

    if ($q) {
        $sql .= " AND (contacto_solicitante LIKE ? OR descripcion LIKE ? OR tecnico_asignado LIKE ?)";
        $p = ["%$q%", "%$q%", "%$q%"];
    }
    
    $sql .= " ORDER BY id DESC LIMIT 100";
    $st = $pdo->prepare($sql);
    $st->execute($p);
    json_ok($st->fetchAll());
}

// Obtener un reporte individual
function ticket_get_action($pdo) {
    auth_require();
    $id = (int)($_POST['id'] ?? 0);
    
    $st = $pdo->prepare("SELECT *, contacto_solicitante as contacto, medio_contacto as medio, 
                                tecnico_asignado as tecnico FROM tickets WHERE id = ?");
    $st->execute([$id]);
    $res = $st->fetch();
    
    if (!$res) json_err("Reporte no encontrado.");
    json_ok($res);
}

// Guardar o Actualizar reporte
function ticket_save_action($pdo) {
    auth_require();
    csrf_check();
    
    $id = (int)($_POST['id'] ?? 0);
    
    // Mapeo de parámetros para evitar errores de orden
    $params = [
        $_POST['fecha_atencion'], $_POST['hora_inicio'], $_POST['hora_fin'],
        $_POST['tipo_atencion'], $_POST['medio'], $_POST['tiempo_invertido'],
        $_POST['oficina'], $_POST['area'], $_POST['contacto'],
        $_POST['tecnico'], $_POST['satisfaccion'], $_POST['categoria'],
        $_POST['prioridad'], $_POST['estado'], $_POST['descripcion'],
        $_POST['observaciones']
    ];

    if ($id > 0) {
        $sql = "UPDATE tickets SET 
                fecha_atencion=?, hora_inicio=?, hora_fin=?, tipo_atencion=?, medio_contacto=?, 
                tiempo_invertido=?, oficina=?, area=?, contacto_solicitante=?, tecnico_asignado=?, 
                satisfaccion=?, categoria=?, prioridad=?, estado=?, descripcion=?, observaciones=? 
                WHERE id=?";
        $params[] = $id;
    } else {
        $sql = "INSERT INTO tickets (
                fecha_atencion, hora_inicio, hora_fin, tipo_atencion, medio_contacto, 
                tiempo_invertido, oficina, area, contacto_solicitante, tecnico_asignado, 
                satisfaccion, categoria, prioridad, estado, descripcion, observaciones
                ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    }

    try {
        $pdo->prepare($sql)->execute($params);
        
        // --- LOGICA DE NOTIFICACIONES INTEGRADA ---
        $ticketId = ($id > 0) ? $id : $pdo->lastInsertId();
        
        // Buscamos los datos actualizados
        $st = $pdo->prepare("SELECT * FROM tickets WHERE id = ?");
        $st->execute([$ticketId]);
        $ticket = $st->fetch();

        // Verificamos si la función existe antes de llamar (evita Fatal Errors)
        if ($ticket && function_exists('enviar_notificacion_ticket')) {
            if ($id == 0) {
                enviar_notificacion_ticket($ticket, 'crear');
            } else {
                $accion = ($ticket->estado === 'Cerrado') ? 'cerrar' : 'estado';
                enviar_notificacion_ticket($ticket, $accion);
            }
        }

        json_ok(['msg' => 'Reporte procesado y notificación enviada correctamente']);
        
    } catch (Exception $e) {
        json_err("Error de base de datos: " . $e->getMessage());
    }
}

// Eliminar reporte (Solo para Administradores de FYCLS)
function ticket_delete_action($pdo) {
    role_require('Admin'); 
    $id = (int)($_POST['id'] ?? 0);
    
    $st = $pdo->prepare("DELETE FROM tickets WHERE id = ?");
    $st->execute([$id]);
    json_ok(['msg' => 'Reporte eliminado correctamente']);
}