<?php
/**
 * UserController - Gestión de Personal y Clientes
 * Sistema: Holman F
 * Cliente: FYCLS SAS
 */

// --- GESTIÓN DE CONTACTOS (CLIENTES EXTERNOS) ---
function contactos_list_action($pdo) {
    auth_require();
    $st = $pdo->query("SELECT * FROM contactos ORDER BY nombre ASC");
    json_ok($st->fetchAll());
}

function contacto_save_action($pdo) {
    auth_require();
    $id = (int)($_POST['id'] ?? 0);
    $nombre = trim($_POST['nombre'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $empresa = trim($_POST['empresa'] ?? '');

    if (empty($nombre) || empty($email)) {
        json_err('El nombre y el email son obligatorios para las notificaciones de FYCLS SAS.');
    }

    // Validación de Duplicados (Email único)
    $check = $pdo->prepare("SELECT id FROM contactos WHERE email = ? AND id != ?");
    $check->execute([$email, $id]);
    if ($check->fetch()) {
        json_err("El correo $email ya está registrado con otro cliente.");
    }

    if ($id === 0) {
        $sql = "INSERT INTO contactos (nombre, email, empresa) VALUES (?, ?, ?)";
        $params = [$nombre, $email, $empresa];
    } else {
        $sql = "UPDATE contactos SET nombre=?, email=?, empresa=? WHERE id=?";
        $params = [$nombre, $email, $empresa, $id];
    }
    
    $pdo->prepare($sql)->execute($params);
    json_ok(['msg' => 'Cliente actualizado correctamente en Holman F']);
}

// --- GESTIÓN DE USUARIOS (PERSONAL INTERNO ST_USUARIOS) ---
function usuarios_list_action($pdo) {
    auth_require();
    // Consultamos específicamente st_usuarios para el personal de FYCLS
    $st = $pdo->query("SELECT id, nombre, username, rol, activo FROM st_usuarios ORDER BY nombre ASC");
    json_ok($st->fetchAll());
}

function usuario_save_action($pdo) {
    auth_require();
    $id = (int)($_POST['id'] ?? 0);
    $nombre = trim($_POST['nombre'] ?? '');
    $user = trim($_POST['username'] ?? '');
    $rol = $_POST['rol'] ?? 'Tecnico';
    
    // Validación de Duplicados (Username único)
    $check = $pdo->prepare("SELECT id FROM st_usuarios WHERE username = ? AND id != ?");
    $check->execute([$user, $id]);
    if ($check->fetch()) {
        json_err("El nombre de usuario '$user' ya está en uso.");
    }

    if ($id === 0) {
        $passRaw = $_POST['password'] ?? '';
        if (empty($passRaw)) json_err('La contraseña es obligatoria para nuevos usuarios.');
        
        $pass = password_hash($passRaw, PASSWORD_DEFAULT);
        $sql = "INSERT INTO st_usuarios (nombre, username, password, rol) VALUES (?, ?, ?, ?)";
        $params = [$nombre, $user, $pass, $rol];
    } else {
        // En actualizaciones no tocamos el password a menos que se implemente un flujo de reset
        $sql = "UPDATE st_usuarios SET nombre=?, username=?, rol=? WHERE id=?";
        $params = [$nombre, $user, $rol, $id];
    }

    $pdo->prepare($sql)->execute($params);
    json_ok(['msg' => 'Personal de FYCLS actualizado en st_usuarios']);
}