<?php
/**
 * Sistema de Notificaciones Holman
 */
function enviar_notificacion_ticket($pdo, $ticket_id, $accion) {
    // Buscamos el ticket y el correo del contacto unido
    $st = $pdo->prepare("
        SELECT t.*, c.email, c.nombre as nombre_contacto 
        FROM tickets t 
        JOIN contactos c ON t.contacto_id = c.id 
        WHERE t.id = ?
    ");
    $st->execute([$ticket_id]);
    $data = $st->fetch();

    if (!$data || empty($data->email)) return false;

    $para = $data->email;
    $asunto = "Actualización Ticket #{$data->id} - FYCLS S.A.S";
    
    // ... resto de la lógica de mail() que definimos antes usando $data->nombre_contacto
}
function enviar_notificacion_ticket($ticket, $accion) {
    // Configuramos el remitente
    $desde = "Holman IA <no-reply@tu-dominio.com>";
    $para  = $ticket->contacto_solicitante; // Asegúrate que este campo sea un email
    
    $asunto = "Actualización de Ticket #{$ticket->id} - " . APP_NAME;
    
    // Definimos el mensaje según la acción
    switch($accion) {
        case 'crear':
            $titulo = "¡Ticket Recibido!";
            $msg = "Hemos registrado tu solicitud. Un técnico ha sido asignado.";
            break;
        case 'estado':
            $titulo = "Actualización de Estado";
            $msg = "Tu ticket ha cambiado de estado a: **{$ticket->estado}**.";
            break;
        case 'cerrar':
            $titulo = "Ticket Cerrado";
            $msg = "Tu solicitud ha sido resuelta. Gracias por confiar en nosotros.";
            break;
    }

    $cuerpo = "
    <html>
    <body style='font-family: sans-serif; color: #333;'>
        <div style='max-width: 600px; margin: auto; border: 1px solid #eee; padding: 20px;'>
            <h2 style='color: #38BDF8;'>{$titulo}</h2>
            <p>Hola <strong>{$ticket->contacto_solicitante}</strong>,</p>
            <p>{$msg}</p>
            <hr style='border: 0; border-top: 1px solid #eee;'>
            <p><strong>Detalles del Ticket:</strong></p>
            <ul>
                <li><strong>Número:</strong> #{$ticket->id}</li>
                <li><strong>Categoría:</strong> {$ticket->categoria}</li>
                <li><strong>Prioridad:</strong> {$ticket->prioridad}</li>
            </ul>
            <p style='font-size: 0.8em; color: #777;'>Este es un mensaje automático generado por Holman IA para TREXDI S.A.S.</p>
        </div>
    </body>
    </html>";

    $headers = "MIME-Version: 1.0" . "\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";
    $headers .= "From: " . $desde . "\r\n";

    return @mail($para, $asunto, $cuerpo, $headers);
}