<?php
require_once __DIR__ . '/config.php';
require_once INC . 'auth.php';

$logged = auth_check();
$user   = $logged ? auth_user() : null;
$csrf   = csrf_token();
$meses  = ['Enero','Febrero','Marzo','Abril','Mayo','Junio','Julio','Agosto','Septiembre','Octubre','Noviembre','Diciembre'];
$ma     = date('n');
$ya     = date('Y');
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Holman F | FYCLS SAS</title>
<link rel="preconnect" href="https://fonts.googleapis.com">
<link href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@300;400;500;600;700&family=JetBrains+Mono:wght@400;500&display=swap" rel="stylesheet">
<link rel="stylesheet" href="assets/style.css">
</head>
<body>

<?php if (!$logged): ?>
<!-- ====== LOGIN ====== -->
<div id="login-wrap">
  <div class="login-card">
    <div class="login-icon">
      <svg viewBox="0 0 48 48" fill="none">
        <circle cx="24" cy="24" r="24" fill="#0F172A"/>
        <path d="M14 24C14 18.48 18.48 14 24 14s10 4.48 10 10-4.48 10-10 10" stroke="#38BDF8" stroke-width="2.5" stroke-linecap="round"/>
        <circle cx="24" cy="24" r="3.5" fill="#38BDF8"/>
        <path d="M24 9v5M24 34v5M9 24h5M34 24h5" stroke="#38BDF8" stroke-width="2" stroke-linecap="round"/>
      </svg>
    </div>
    <h1>Soporte Técnico</h1>
    <p class="sub">FYCLS SAS — Sistema de Gestión</p>
    <div id="login-err" class="alert err" style="display:none"></div>
    <div class="field">
      <label>Usuario</label>
      <input id="u" type="text" placeholder="Ingresa tu usuario" autocomplete="username" autofocus>
    </div>
    <div class="field">
      <label>Contraseña</label>
      <input id="p" type="password" placeholder="••••••••" autocomplete="current-password">
    </div>
    <button id="btn-login" class="btn primary full">Ingresar al sistema</button>
    <p class="hint">Acceso restringido al personal autorizado</p>
  </div>
</div>

<?php else: ?>
<!-- ====== APP ====== -->
<div id="app">

  <!-- SIDEBAR -->
  <aside id="sidebar">
    <div class="sb-logo">
      <svg viewBox="0 0 32 32" fill="none">
        <circle cx="16" cy="16" r="16" fill="#0F172A"/>
        <path d="M9 16C9 12.13 12.13 9 16 9s7 3.13 7 7-3.13 7-7 7" stroke="#38BDF8" stroke-width="2" stroke-linecap="round"/>
        <circle cx="16" cy="16" r="2.5" fill="#38BDF8"/>
      </svg>
      <span>FYCLS SAS</span>
    </div>

    <nav>
      <a class="nav active" data-v="dashboard">
        <svg viewBox="0 0 20 20" fill="currentColor"><path d="M2 11h7V2H2v9zm0 7h7v-5H2v5zm9 0h7v-9h-7v9zm0-16v5h7V2h-7z"/></svg>
        Dashboard
      </a>
      <a class="nav" data-v="lista">
        <svg viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M4 4a2 2 0 012-2h8a2 2 0 012 2v12a2 2 0 01-2 2H6a2 2 0 01-2-2V4zm5 3a1 1 0 000 2h4a1 1 0 000-2H9zm-1 4a1 1 0 011-1h4a1 1 0 010 2H9a1 1 0 01-1-1zm0 3a1 1 0 011-1h4a1 1 0 010 2H9a1 1 0 01-1-1z" clip-rule="evenodd"/></svg>
        Registros
      </a>
      <a class="nav" data-v="nuevo">
        <svg viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 3a1 1 0 011 1v5h5a1 1 0 110 2h-5v5a1 1 0 11-2 0v-5H4a1 1 0 110-2h5V4a1 1 0 011-1z" clip-rule="evenodd"/></svg>
        Nuevo Reporte
      </a>
      <a class="nav" data-v="buscar">
        <svg viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M8 4a4 4 0 100 8 4 4 0 000-8zM2 8a6 6 0 1110.89 3.476l4.817 4.817a1 1 0 01-1.414 1.414l-4.816-4.816A6 6 0 012 8z" clip-rule="evenodd"/></svg>
        Buscar Soluciones
      </a>
      <a class="nav" data-v="ia">
        <svg viewBox="0 0 20 20" fill="currentColor"><path d="M13 7H7v6h6V7z"/><path fill-rule="evenodd" d="M7 2a1 1 0 012 0v1h2V2a1 1 0 112 0v1h2a2 2 0 012 2v2h1a1 1 0 110 2h-1v2h1a1 1 0 110 2h-1v2a2 2 0 01-2 2h-2v1a1 1 0 11-2 0v-1H9v1a1 1 0 11-2 0v-1H5a2 2 0 01-2-2v-2H2a1 1 0 110-2h1V9H2a1 1 0 010-2h1V5a2 2 0 012-2h2V2zM5 5h10v10H5V5z" clip-rule="evenodd"/></svg>
        Asistente IA
      </a>

      <div class="nav-sep">ADMINISTRACIÓN</div>

      <a class="nav" data-v="contactos">
        <svg viewBox="0 0 20 20" fill="currentColor"><path d="M9 6a3 3 0 11-6 0 3 3 0 016 0zM17 6a3 3 0 11-6 0 3 3 0 016 0zM12.93 17c.046-.327.07-.66.07-1a6.97 6.97 0 00-1.5-4.33A5 5 0 0119 16v1h-6.07zM6 11a5 5 0 015 5v1H1v-1a5 5 0 015-5z"/></svg>
        Clientes
      </a>
      <a class="nav" data-v="usuarios">
        <svg viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-6-3a2 2 0 11-4 0 2 2 0 014 0zm-2 4a5 5 0 00-4.546 2.916A5.986 5.986 0 0010 16a5.986 5.986 0 004.546-2.084A5 5 0 0010 11z" clip-rule="evenodd"/></svg>
        Personal
      </a>
    </nav>

    <div class="sb-footer">
      <div class="user-info">
        <div class="avatar"><?= strtoupper(mb_substr($user['nombre'],0,1)) ?></div>
        <div>
          <div class="uname"><?= htmlspecialchars($user['nombre']) ?></div>
          <div class="urole"><?= htmlspecialchars($user['rol']) ?></div>
        </div>
      </div>
      <button id="btn-logout" title="Cerrar sesión">
        <svg viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M3 3a1 1 0 00-1 1v12a1 1 0 102 0V4a1 1 0 00-1-1zm10.293 9.293a1 1 0 001.414 1.414l3-3a1 1 0 000-1.414l-3-3a1 1 0 10-1.414 1.414L14.586 9H7a1 1 0 100 2h7.586l-1.293 1.293z" clip-rule="evenodd"/></svg>
      </button>
    </div>
  </aside>

  <!-- MAIN -->
  <main>
    <header id="topbar">
      <button id="menu-toggle">
        <svg viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M3 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 5a1 1 0 011-1h12a1 1 0 110 2H4a1 1 0 01-1-1zm0 5a1 1 0 011-1h6a1 1 0 110 2H4a1 1 0 01-1-1z" clip-rule="evenodd"/></svg>
      </button>
      <span id="breadcrumb">Dashboard</span>
      <div id="timer-wrap">Sesión: <span id="timer">30:00</span></div>
    </header>

    <div id="content">

      <!-- ====== DASHBOARD ====== -->
      <section id="v-dashboard" class="view active">
        <div class="ph">
          <h2>Dashboard</h2>
          <div class="row-g">
            <select id="d-mes" class="sel-sm">
              <?php foreach($meses as $i=>$m): ?>
              <option value="<?=$i+1?>" <?=$i+1==$ma?'selected':''?>><?=$m?></option>
              <?php endforeach; ?>
            </select>
            <select id="d-anio" class="sel-sm">
              <?php for($y=$ya;$y>=$ya-3;$y--): ?>
              <option value="<?=$y?>"><?=$y?></option>
              <?php endfor; ?>
            </select>
            <button class="btn sm" id="d-refresh">Actualizar</button>
          </div>
        </div>
        <div class="kpi-grid">
          <div class="kpi blue">  <span class="ki">📋</span><span class="kv" id="k-total">—</span><span class="kl">Total reportes</span></div>
          <div class="kpi orange"><span class="ki">🔴</span><span class="kv" id="k-ab">—</span><span class="kl">Abiertos</span></div>
          <div class="kpi teal">  <span class="ki">🔄</span><span class="kv" id="k-ep">—</span><span class="kl">En proceso</span></div>
          <div class="kpi green"> <span class="ki">✅</span><span class="kv" id="k-cl">—</span><span class="kl">Cerrados</span></div>
          <div class="kpi red">   <span class="ki">⚡</span><span class="kv" id="k-alta">—</span><span class="kl">Alta prioridad</span></div>
          <div class="kpi purple"><span class="ki">⭐</span><span class="kv" id="k-sat">—</span><span class="kl">Satisfacción</span></div>
        </div>
        <div class="charts-grid">
          <div class="card"><h3>Reportes por día</h3><canvas id="ch-dias"></canvas></div>
          <div class="card"><h3>Por categoría</h3><canvas id="ch-cats"></canvas></div>
          <div class="card"><h3>Por estado</h3><canvas id="ch-estado"></canvas></div>
          <div class="card"><h3>Top técnicos</h3><div id="top-tec"></div></div>
        </div>
      </section>

      <!-- ====== LISTA REPORTES ====== -->
      <section id="v-lista" class="view">
        <div class="ph">
          <h2>Registros de Soporte</h2>
          <button class="btn primary" data-v="nuevo">+ Nuevo</button>
        </div>
        <div class="filters">
          <input id="f-q" class="inp" placeholder="Buscar...">
          <select id="f-est" class="sel"><option value="">Estado</option><option>Abierto</option><option>En proceso</option><option>Pendiente</option><option>Cerrado</option></select>
          <select id="f-pri" class="sel"><option value="">Prioridad</option><option>Baja</option><option>Media</option><option>Alta</option><option>Crítica</option></select>
          <select id="f-cat" class="sel"><option value="">Categoría</option><option>Red</option><option>Hardware</option><option>Software</option><option>Correo</option><option>Impresora</option><option>Acceso</option><option>Otro</option></select>
          <button class="btn sm" id="btn-filtrar">Filtrar</button>
          <button class="btn sm ghost" id="btn-limpiar">Limpiar</button>
        </div>
        <div class="tbl-wrap">
          <table class="tbl">
            <thead><tr><th>#</th><th>Fecha</th><th>Cliente</th><th>Categoría</th><th>Técnico</th><th>Prioridad</th><th>Estado</th><th></th></tr></thead>
            <tbody id="tbody"></tbody>
          </table>
        </div>
      </section>

      <!-- ====== NUEVO / EDITAR REPORTE ====== -->
      <section id="v-nuevo" class="view">
        <div class="ph"><h2 id="form-h">Nuevo Reporte</h2></div>
        <form id="rep-form">
          <input type="hidden" id="r-id" value="0">
          <div class="fsec">
            <div class="fsh">Información del requerimiento</div>
            <div class="g3">
              <div class="field"><label>Fecha de atención *</label><input type="date" id="r-fecha" class="inp" required></div>
              <div class="field"><label>Hora inicio</label><input type="time" id="r-hini" class="inp"></div>
              <div class="field"><label>Hora fin</label><input type="time" id="r-hfin" class="inp"></div>
            </div>
            <div class="g3">
              <div class="field"><label>Tipo de atención</label>
                <select id="r-tipo" class="inp"><option>Presencial</option><option>Remoto</option><option>Telefónico</option><option>WhatsApp</option></select></div>
              <div class="field"><label>Medio de contacto</label>
                <select id="r-medio" class="inp"><option>WhatsApp</option><option>Correo</option><option>Teléfono</option><option>Presencial</option><option>Sistema</option></select></div>
              <div class="field"><label>Tiempo invertido</label><input type="text" id="r-tiempo" class="inp" placeholder="ej: 01:30 h"></div>
            </div>
          </div>

          <div class="fsec">
            <div class="fsh">Involucrados</div>
            <div class="g2">
              <div class="field"><label>Cliente</label>
                <select id="r-contacto-id" class="inp"><option value="">-- Seleccione Cliente --</option></select>
              </div>
              <div class="field"><label>Técnico asignado</label>
                <input type="text" id="r-tec" class="inp" placeholder="Nombre del técnico">
              </div>
            </div>
            <div class="g3">
              <div class="field"><label>Oficina</label><input type="text" id="r-ofic" class="inp"></div>
              <div class="field"><label>Área</label><input type="text" id="r-area" class="inp"></div>
              <div class="field"><label>Satisfacción (0–5)</label><input type="number" id="r-sat" class="inp" min="0" max="5" value="0"></div>
            </div>
          </div>

          <div class="fsec">
            <div class="fsh">Clasificación</div>
            <div class="g3">
              <div class="field"><label>Categoría</label>
                <select id="r-cat" class="inp"><option value="">Seleccionar...</option><option>Red</option><option>Hardware</option><option>Software</option><option>Correo</option><option>Impresora</option><option>Acceso</option><option>Otro</option></select></div>
              <div class="field"><label>Prioridad</label>
                <select id="r-pri" class="inp"><option>Baja</option><option selected>Media</option><option>Alta</option><option>Crítica</option></select></div>
              <div class="field"><label>Estado</label>
                <select id="r-est" class="inp"><option>Abierto</option><option>En proceso</option><option>Pendiente</option><option>Cerrado</option></select></div>
            </div>
          </div>

          <div class="fsec">
            <div class="fsh">Detalle</div>
            <div class="field">
              <label>Descripción del problema *</label>
              <textarea id="r-desc" class="inp ta" rows="4" placeholder="Describe el problema con detalle..." required></textarea>
              <button type="button" id="btn-ia-form" class="ia-hint">🤖 Sugerencias IA</button>
            </div>
            <div id="ia-form-res" class="ia-box" style="display:none"></div>
            <div class="field">
              <label>Observaciones / Solución aplicada</label>
              <textarea id="r-obs" class="inp ta" rows="3" placeholder="Solución aplicada..."></textarea>
            </div>
          </div>

          <div class="form-acts">
            <button type="button" class="btn ghost" data-v="lista">Cancelar</button>
            <button type="submit" class="btn primary" id="btn-save">💾 Guardar reporte</button>
          </div>
        </form>
      </section>

      <!-- ====== BUSCAR ====== -->
      <section id="v-buscar" class="view">
        <div class="ph"><h2>Buscar en Base de Conocimiento</h2></div>
        <div class="search-hero">
          <input id="busq-inp" class="inp search-inp" placeholder="Describe el problema...">
          <button id="btn-buscar" class="btn primary">Buscar</button>
        </div>
        <div id="busq-res"></div>
      </section>

      <!-- ====== ASISTENTE IA ====== -->
      <section id="v-ia" class="view">
        <div class="ph"><h2>🤖 Asistente IA — FYCLS</h2></div>
        <div class="ia-layout">
          <div class="fsec">
            <div class="fsh">Describe el problema</div>
            <div class="field">
              <label>Descripción</label>
              <textarea id="ia-desc" class="inp ta" rows="5" placeholder="Ej: El equipo no enciende..."></textarea>
            </div>
            <div class="g2">
              <div class="field"><label>Categoría</label>
                <select id="ia-cat" class="inp"><option value="">Auto-detectar</option><option>Red</option><option>Hardware</option><option>Software</option><option>Correo</option><option>Impresora</option><option>Acceso</option></select>
              </div>
              <div class="field"><label>Prioridad</label>
                <select id="ia-prio" class="inp"><option value="">Sin especificar</option><option>Baja</option><option>Media</option><option>Alta</option><option>Crítica</option></select>
              </div>
            </div>
            <button id="btn-ia" class="btn primary">🔍 Analizar</button>
          </div>
          <div id="ia-res"></div>
        </div>
      </section>

      <!-- ====== CLIENTES ====== -->
      <section id="v-contactos" class="view">
        <div class="ph">
          <h2>Clientes</h2>
          <button class="btn primary" onclick="nuevoContacto()">+ Nuevo Cliente</button>
        </div>
        <div class="tbl-wrap">
          <table class="tbl">
            <thead><tr><th>Nombre</th><th>Empresa</th><th>Email</th><th></th></tr></thead>
            <tbody id="tbody-contactos"><tr><td colspan="4" class="tc">Cargando...</td></tr></tbody>
          </table>
        </div>
      </section>

      <!-- ====== PERSONAL ====== -->
      <section id="v-usuarios" class="view">
        <div class="ph">
          <h2>Personal</h2>
          <button class="btn primary" onclick="nuevoUsuario()">+ Nuevo Usuario</button>
        </div>
        <div class="tbl-wrap">
          <table class="tbl">
            <thead><tr><th>Nombre</th><th>Usuario</th><th>Rol</th><th>Estado</th><th></th></tr></thead>
            <tbody id="tbody-usuarios"><tr><td colspan="5" class="tc">Cargando...</td></tr></tbody>
          </table>
        </div>
      </section>

    </div><!-- /content -->
  </main>
</div><!-- /app -->

<!-- MODAL DETALLE REPORTE -->
<div id="modal" style="display:none">
  <div class="modal-box">
    <div class="modal-h">
      <h3 id="modal-t">Detalle</h3>
      <button class="modal-cl" id="modal-cl">✕</button>
    </div>
    <div class="modal-b" id="modal-b"></div>
    <div class="modal-f">
      <button class="btn ghost" id="modal-cl2">Cerrar</button>
      <button class="btn primary" id="modal-edit">✏️ Editar</button>
    </div>
  </div>
</div>

<!-- MODAL ADMIN: Contactos / Usuarios -->
<div id="modal-admin" style="display:none">
  <div class="modal-box">
    <div class="modal-h">
      <h3 id="modal-admin-t">Nuevo</h3>
      <button class="modal-cl" onclick="cerrarModalAdmin()">✕</button>
    </div>
    <form id="form-admin">
      <input type="hidden" id="admin-tipo" value="">
      <input type="hidden" id="admin-id" value="0">
      <div class="modal-b" id="modal-admin-body"></div>
      <div class="modal-f">
        <button type="button" class="btn ghost" onclick="cerrarModalAdmin()">Cancelar</button>
        <button type="submit" class="btn primary">💾 Guardar</button>
      </div>
    </form>
  </div>
</div>

<?php endif; ?>

<script>
const CSRF       = <?= json_encode($csrf) ?>;
const LOGGED     = <?= json_encode($logged) ?>;
const IS_ADMIN   = <?= json_encode(($user['rol'] ?? '') === 'admin') ?>;
const SESSION_EXP= <?= json_encode($_SESSION['exp'] ?? time()+1800) ?>;
</script>
<script src="assets/app.js"></script>
</body>
</html>
