<?php
// Corre UNA SOLA VEZ para crear la tabla st_contactos
// Accede a: tudominio.com/soporte/migrar.php
// BÓRRALO después

require_once 'config.php';

try {
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS st_contactos (
            id         INT AUTO_INCREMENT PRIMARY KEY,
            nombre     VARCHAR(160) NOT NULL,
            empresa    VARCHAR(160),
            email      VARCHAR(160),
            telefono   VARCHAR(40),
            creado     DATETIME DEFAULT CURRENT_TIMESTAMP,
            actualizado DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    ");

    // Agregar columna contacto_id a st_reportes si no existe
    $cols = $pdo->query("SHOW COLUMNS FROM st_reportes LIKE 'contacto_id'")->fetchAll();
    if (empty($cols)) {
        $pdo->exec("ALTER TABLE st_reportes ADD COLUMN contacto_id INT NULL AFTER nro");
    }

    echo '<div style="font-family:monospace;padding:40px;background:#0f172a;color:#4ade80;border-radius:12px;max-width:500px;margin:60px auto;text-align:center">
        <div style="font-size:2rem;margin-bottom:16px">✅</div>
        <b>Migración completada</b><br><br>
        Tabla <code>st_contactos</code> creada.<br>
        Columna <code>contacto_id</code> agregada a st_reportes.<br><br>
        <span style="color:#f87171">⚠️ Elimina este archivo ahora (migrar.php)</span><br><br>
        <a href="index.php" style="color:#38bdf8">→ Ir al sistema</a>
    </div>';

} catch(Exception $e) {
    echo '<div style="font-family:monospace;padding:40px;background:#0f172a;color:#f87171;border-radius:12px;max-width:500px;margin:60px auto">
        ❌ Error: ' . htmlspecialchars($e->getMessage()) . '
    </div>';
}
