<?php
require_once __DIR__ . '/../config.php';
require_once INC . 'auth.php';
require_once INC . 'reportes.php';
require_once INC . 'ia.php';

$action = $_POST['action'] ?? $_GET['action'] ?? '';

// Acciones públicas
if ($action === 'login') {
    csrf_check();
    $r = auth_login($pdo, $_POST['username'] ?? '', $_POST['password'] ?? '');
    $r['ok'] ? json_ok($r) : json_err($r['msg']);
}

if ($action === 'logout') {
    auth_logout();
    json_ok();
}

// Todas las demás requieren autenticación
csrf_check();
if (!auth_check()) json_err('Sesión expirada.');

switch ($action) {

    case 'reportes':
        json_ok(rep_list($pdo, [
            'estado'    => $_POST['estado']    ?? '',
            'prioridad' => $_POST['prioridad'] ?? '',
            'categoria' => $_POST['categoria'] ?? '',
            'tecnico'   => $_POST['tecnico']   ?? '',
            'q'         => $_POST['q']         ?? '',
            'mes'       => $_POST['mes']       ?? '',
            'anio'      => $_POST['anio']      ?? '',
        ]));

    case 'reporte_get':
        $r = rep_get($pdo, (int)($_POST['id'] ?? 0));
        $r ? json_ok($r) : json_err('No encontrado.');

    case 'reporte_save':
        $id = (int)($_POST['id'] ?? 0);
        $newId = rep_save($pdo, $_POST, $id);
        json_ok(['id' => $newId, 'msg' => $id ? 'Actualizado.' : 'Creado.']);

    case 'reporte_delete':
        if (!is_admin()) json_err('Sin permisos.');
        rep_delete($pdo, (int)($_POST['id'] ?? 0));
        json_ok(['msg' => 'Eliminado.']);

    case 'dashboard':
        json_ok(rep_dashboard($pdo, (int)($_POST['mes'] ?? date('n')), (int)($_POST['anio'] ?? date('Y'))));

    case 'buscar':
        json_ok(rep_buscar_cerrados($pdo, $_POST['q'] ?? ''));

    case 'ia':
        json_ok(ia_sugerencias($pdo, $_POST['desc'] ?? '', $_POST['cat'] ?? '', $_POST['prio'] ?? ''));

    default:
        json_err('Acción desconocida.');
}
