<?php
// ============================================================
//  CONFIGURACIÓN — edita solo este archivo
// ============================================================

define('DB_HOST', 'localhost');
define('DB_NAME', 'tu_base_de_datos');   // nombre de tu BD en cPanel
define('DB_USER', 'tu_usuario');          // usuario MySQL de cPanel
define('DB_PASS', 'tu_contraseña');       // contraseña MySQL

define('APP_NAME', 'Soporte Técnico');
define('APP_URL',  '');                   // déjalo vacío; se detecta automáticamente
define('SESSION_MINUTES', 30);            // minutos de sesión

// ============================================================
//  NO MODIFICAR LO DE ABAJO
// ============================================================
define('ROOT', __DIR__);
define('INC',  ROOT . '/includes/');

session_start();

// Conexión PDO
try {
    $pdo = new PDO(
        'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4',
        DB_USER, DB_PASS,
        [
            PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_OBJ,
            PDO::ATTR_EMULATE_PREPARES   => false,
        ]
    );
} catch (PDOException $e) {
    die('<div style="font-family:monospace;padding:30px;background:#1e293b;color:#f87171;border-radius:10px;margin:40px auto;max-width:600px">
        <b>❌ Error de conexión a la base de datos</b><br><br>
        Verifica los datos en <code>config.php</code><br><br>
        <small>' . htmlspecialchars($e->getMessage()) . '</small>
    </div>');
}

// Helper response JSON
function json_ok($data = [])  { header('Content-Type: application/json'); echo json_encode(['ok' => true,  'data' => $data]); exit; }
function json_err($msg = '')  { header('Content-Type: application/json'); echo json_encode(['ok' => false, 'msg'  => $msg]);  exit; }

// CSRF token
function csrf_token() {
    if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(24));
    return $_SESSION['csrf'];
}
function csrf_check() {
    $t = $_POST['_csrf'] ?? $_SERVER['HTTP_X_CSRF_TOKEN'] ?? '';
    if (!hash_equals($_SESSION['csrf'] ?? '', $t)) json_err('Token inválido. Recarga la página.');
}
