<?php
function ia_sugerencias(PDO $pdo, string $desc, string $cat = '', string $prio = ''): array {
    $d = mb_strtolower(trim($desc));

    $kb = [
        'Red' => [
            ['kw'=>['sin internet','no conecta','sin conexión','no navega','internet caído','sin red'],
             'titulo'=>'Sin conectividad a Internet',
             'pasos'=>['Verificar cable de red conectado al equipo y al switch/router.',
                       'Reiniciar el router: apagarlo 30 segundos y volver a encender.',
                       'En Windows: Ejecutar → cmd → ipconfig /release y luego ipconfig /renew.',
                       'Hacer ping a 8.8.8.8 para descartar problema de DNS.',
                       'Si el ping funciona: limpiar DNS con ipconfig /flushdns.',
                       'Verificar si otros equipos del mismo switch tienen el mismo fallo.',
                       'Revisar si hay conflicto de IPs (IP duplicada en la red).'],
             'tiempo'=>'15–30 min','prio_sug'=>'Alta'],

            ['kw'=>['lento','red lenta','internet lento','latencia','lag','se corta'],
             'titulo'=>'Red lenta o inestable',
             'pasos'=>['Hacer test de velocidad en speedtest.net desde el equipo afectado.',
                       'Verificar si el problema es solo en ese equipo o en toda la red.',
                       'Revisar uso de ancho de banda con GlassWire o el panel del router.',
                       'Cambiar cable de red (puede estar dañado o ser de baja calidad).',
                       'Verificar configuración QoS en el router si hay muchos usuarios.',
                       'Considerar separar tráfico en VLAN si la red está saturada.'],
             'tiempo'=>'20–45 min','prio_sug'=>'Media'],

            ['kw'=>['vpn','no entra vpn','vpn no conecta','red privada'],
             'titulo'=>'VPN no conecta',
             'pasos'=>['Verificar que el usuario y contraseña VPN sean correctos y vigentes.',
                       'Confirmar que el servidor VPN esté activo y accesible.',
                       'Revisar firewall: desbloquear puertos 443 (SSL-VPN) o 1194 (OpenVPN).',
                       'Verificar si los certificados VPN están vencidos.',
                       'Reinstalar el cliente VPN si el problema persiste.',
                       'Probar desde otra red (datos móviles) para aislar el problema.'],
             'tiempo'=>'20–40 min','prio_sug'=>'Alta'],

            ['kw'=>['wifi','inalámbrico','no ve el wifi','señal débil'],
             'titulo'=>'Problema con WiFi',
             'pasos'=>['Verificar que el adaptador WiFi esté habilitado (Fn+F2 o desde Configuración).',
                       'Olvidar la red y volver a conectar ingresando la contraseña.',
                       'Actualizar driver del adaptador WiFi desde el sitio del fabricante.',
                       'Probar acercar el equipo al router para descartar distancia.',
                       'Revisar si el canal WiFi del router está saturado (usar app WiFi Analyzer).',
                       'Si usa 5GHz y hay paredes, cambiar a 2.4GHz.'],
             'tiempo'=>'15–30 min','prio_sug'=>'Media'],
        ],

        'Hardware' => [
            ['kw'=>['no enciende','no prende','no arranca','sin imagen','no bootea','equipo muerto'],
             'titulo'=>'Equipo no enciende',
             'pasos'=>['Verificar que el cable de poder esté bien conectado al equipo y al tomacorriente.',
                       'Probar en otro tomacorriente o regleta.',
                       'Revisar si el LED de la fuente enciende al conectar.',
                       'Intentar reset de BIOS: desconectar corriente, retirar batería CMOS 30 segundos.',
                       'Probar con solo 1 módulo de RAM para descartar fallo de memoria.',
                       'Si no hay ninguna señal de vida: posible fallo de fuente de poder, reemplazar.',
                       'Si hay pitidos al encender: consultar tabla de beep codes del fabricante.'],
             'tiempo'=>'30–90 min','prio_sug'=>'Alta'],

            ['kw'=>['pantalla azul','bsod','blue screen','pantalla azul de la muerte','error crítico windows'],
             'titulo'=>'Pantalla azul (BSOD)',
             'pasos'=>['Anotar el código STOP que aparece en pantalla (ej: IRQL_NOT_LESS_OR_EQUAL).',
                       'Reiniciar en Modo Seguro (F8 al iniciar) para aislar el origen.',
                       'Revisar últimas actualizaciones o drivers instalados y revertirlos.',
                       'Ejecutar en CMD como admin: sfc /scannow',
                       'Ejecutar: DISM /Online /Cleanup-Image /RestoreHealth',
                       'Revisar RAM con Windows Memory Diagnostic o MemTest86 (mínimo 2 pasadas).',
                       'Ver Event Viewer → Windows Logs → System para errores críticos.'],
             'tiempo'=>'45–120 min','prio_sug'=>'Alta'],

            ['kw'=>['disco lleno','sin espacio','almacenamiento','disco duro lleno','no hay espacio'],
             'titulo'=>'Disco lleno / sin espacio',
             'pasos'=>['Abrir Explorador de archivos → clic derecho en C: → Propiedades para ver espacio.',
                       'Ejecutar Liberador de espacio en disco (cleanmgr) y limpiar archivos de sistema.',
                       'Revisar carpeta C:/Users/[usuario]/Downloads y limpiar archivos viejos.',
                       'Vaciar la Papelera de reciclaje.',
                       'Usar WinDirStat para identificar qué carpeta ocupa más espacio.',
                       'Mover archivos grandes (videos, backups) a disco externo o servidor.',
                       'Verificar salud del disco con CrystalDiskInfo antes de proceder.'],
             'tiempo'=>'20–60 min','prio_sug'=>'Media'],

            ['kw'=>['teclado','mouse','ratón','no funciona teclado','no responde mouse','periférico'],
             'titulo'=>'Periférico no funciona (teclado / mouse)',
             'pasos'=>['Desconectar y reconectar el dispositivo. Probar en otro puerto USB.',
                       'Probar el dispositivo en otro equipo para confirmar si es hardware.',
                       'Revisar Administrador de dispositivos: buscar símbolo amarillo de error.',
                       'Desinstalar y reinstalar el driver del dispositivo.',
                       'Para teclado: probar en BIOS para confirmar que no es problema de Windows.',
                       'Si es inalámbrico: cambiar pilas y re-emparejar el receptor USB.'],
             'tiempo'=>'10–25 min','prio_sug'=>'Baja'],

            ['kw'=>['caliente','sobrecalenta','se apaga solo','ventilador ruidoso','fan','temperatura'],
             'titulo'=>'Equipo con sobrecalentamiento',
             'pasos'=>['Verificar que los ventiladores estén girando correctamente.',
                       'Limpiar el polvo interno con aire comprimido (especial en disipador de CPU).',
                       'Verificar temperatura con HWMonitor o SpeedFan.',
                       'Si supera 90°C en CPU: revisar y reemplazar pasta térmica.',
                       'Asegurar que el equipo tenga ventilación adecuada alrededor.',
                       'Revisar que el plan de energía no esté en "Alto rendimiento" innecesariamente.'],
             'tiempo'=>'30–60 min','prio_sug'=>'Alta'],
        ],

        'Software' => [
            ['kw'=>['virus','malware','infectado','ransomware','pop-up','antivirus','troyano'],
             'titulo'=>'Infección por malware / virus',
             'pasos'=>['AISLAR el equipo de la red INMEDIATAMENTE (desconectar cable y/o WiFi).',
                       'NO reiniciar si se sospecha de ransomware (puede cifrar más archivos).',
                       'Identificar variante de ransomware en nomoreransom.org antes de actuar.',
                       'Ejecutar escaneo completo con Malwarebytes (versión gratuita) desde USB.',
                       'Revisar procesos sospechosos en Administrador de Tareas.',
                       'Revisar programas de inicio: msconfig → Inicio.',
                       'Si el sistema está gravemente comprometido: formatear y restaurar desde backup verificado.'],
             'tiempo'=>'60–240 min','prio_sug'=>'Crítica'],

            ['kw'=>['lento','pc lenta','equipo lento','tarda mucho','se congela','cuelga'],
             'titulo'=>'Equipo lento o con congelamiento',
             'pasos'=>['Abrir Administrador de Tareas (Ctrl+Shift+Esc) y revisar % de CPU, RAM y Disco.',
                       'Identificar el proceso que consume más recursos.',
                       'Deshabilitar programas de inicio innecesarios (Tarea → pestaña Inicio).',
                       'Si el disco muestra 100% de uso constante, puede estar fallando.',
                       'Limpiar temporales: Ejecutar → %temp% y eliminar todo.',
                       'Si la RAM es de 4GB o menos: es el momento de ampliarla a 8GB.',
                       'Verificar si hay actualizaciones en segundo plano consumiendo recursos.'],
             'tiempo'=>'30–60 min','prio_sug'=>'Media'],

            ['kw'=>['no abre','no instala','error al abrir','se cierra','se cuelga el programa','aplicación'],
             'titulo'=>'Aplicación no abre o falla',
             'pasos'=>['Revisar Event Viewer → Application para ver el error exacto.',
                       'Intentar ejecutar como Administrador (clic derecho → Ejecutar como administrador).',
                       'Reparar instalación: Panel de control → Programas → seleccionar → Reparar.',
                       'Desinstalar completamente y reinstalar desde fuente oficial.',
                       'Verificar compatibilidad del programa con Windows (clic derecho → Propiedades → Compatibilidad).',
                       'Verificar que .NET Framework o Visual C++ Redistributable requeridos estén instalados.'],
             'tiempo'=>'20–50 min','prio_sug'=>'Media'],

            ['kw'=>['windows update','actualización','error de actualización','no actualiza','windows no actualiza'],
             'titulo'=>'Error en actualizaciones de Windows',
             'pasos'=>['Ejecutar el Solucionador integrado: Configuración → Actualización → Solucionar problemas.',
                       'Parar el servicio: net stop wuauserv (CMD como admin).',
                       'Eliminar caché: borrar todo el contenido de C:/Windows/SoftwareDistribution/Download.',
                       'Reiniciar servicio: net start wuauserv.',
                       'Ejecutar: DISM /Online /Cleanup-Image /RestoreHealth',
                       'Luego: sfc /scannow y reiniciar.',
                       'Verificar que haya al menos 10GB libres en C:.'],
             'tiempo'=>'30–90 min','prio_sug'=>'Baja'],
        ],

        'Correo' => [
            ['kw'=>['no llega correo','correo','email','outlook','no envía','no recibe','mail'],
             'titulo'=>'Problema con correo electrónico',
             'pasos'=>['Verificar si el problema ocurre también en webmail (navegador) o solo en Outlook.',
                       'Revisar si la bandeja de entrada tiene filtros o reglas activas que muevan correos.',
                       'Verificar que la cuota de almacenamiento no esté al límite.',
                       'En Outlook: Archivo → Configuración de la cuenta → seleccionar cuenta → Probar.',
                       'Revisar configuración SMTP/IMAP: host, puerto y SSL deben coincidir con los del proveedor.',
                       'Crear un nuevo perfil de Outlook si el actual está corrupto.',
                       'Revisar que el antivirus no esté bloqueando el escaneo de correos.'],
             'tiempo'=>'20–45 min','prio_sug'=>'Media'],
        ],

        'Impresora' => [
            ['kw'=>['impresora','no imprime','atasco','papel atascado','tóner','tinta','cola de impresión'],
             'titulo'=>'Problema con impresora',
             'pasos'=>['Verificar que la impresora esté encendida, con papel y en línea.',
                       'Revisar la cola de impresión: puede haber un trabajo bloqueado.',
                       'Limpiar cola: CMD admin → net stop spooler → borrar contenido de C:/Windows/System32/spool/PRINTERS → net start spooler.',
                       'Verificar nivel de tóner o tinta desde el software de la impresora.',
                       'Revisar si hay papel atascado y limpiar rodillos con paño húmedo.',
                       'Desinstalar y reinstalar el driver desde el sitio oficial del fabricante.',
                       'Si es red: verificar IP de la impresora (puede haber cambiado).'],
             'tiempo'=>'15–35 min','prio_sug'=>'Baja'],
        ],

        'Acceso' => [
            ['kw'=>['contraseña','password','no puede entrar','acceso denegado','bloqueado','no recuerda','olvido clave'],
             'titulo'=>'Problema de acceso / contraseña',
             'pasos'=>['Verificar que el Bloq Mayús esté desactivado.',
                       'Intentar recuperación de contraseña por el proceso estándar.',
                       'Si es cuenta de dominio: restablecer desde Active Directory (Panel de admin).',
                       'Verificar si la cuenta no está bloqueada por múltiples intentos fallidos.',
                       'Si es cuenta local: usar herramienta de recuperación desde USB de Windows.',
                       'Documentar el cambio y notificar al usuario por canal seguro.'],
             'tiempo'=>'10–25 min','prio_sug'=>'Media'],
        ],
    ];

    // Detectar categorías relevantes por coincidencia de palabras clave
    $catKw = [
        'Red'=>['internet','red','conexión','wifi','vpn','router','switch','ip','lan','ping'],
        'Hardware'=>['equipo','pc','computadora','teclado','mouse','disco','ram','encender','pantalla','monitor','impresora'],
        'Software'=>['programa','aplicación','windows','virus','malware','lento','instalar','error','actualiz'],
        'Correo'=>['correo','email','outlook','smtp','imap','mail'],
        'Impresora'=>['impresora','imprimir','tóner','tinta','papel'],
        'Acceso'=>['contraseña','password','acceso','login','bloqueado','usuario'],
    ];

    $scores = [];
    foreach ($catKw as $c => $kws) {
        $scores[$c] = 0;
        foreach ($kws as $kw) if (str_contains($d, $kw)) $scores[$c]++;
        if (mb_strtolower($cat) === mb_strtolower($c)) $scores[$c] += 5;
    }
    arsort($scores);

    $sugerencias = [];
    foreach (array_keys($scores) as $c) {
        if (!isset($kb[$c])) continue;
        foreach ($kb[$c] as $item) {
            $hit = false;
            foreach ($item['kw'] as $kw) if (str_contains($d, $kw)) { $hit = true; break; }
            $topCat = array_key_first($scores);
            if ($hit || ($c === $topCat && $scores[$c] > 0)) {
                $sugerencias[] = [
                    'titulo'    => $item['titulo'],
                    'pasos'     => $item['pasos'],
                    'tiempo'    => $item['tiempo'],
                    'prio_sug'  => $item['prio_sug'],
                    'categoria' => $c,
                    'confianza' => $hit ? 'Alta' : 'Media',
                ];
                if (count($sugerencias) >= 3) break 2;
            }
        }
    }

    $historial = rep_buscar_cerrados($pdo, $desc);

    return [
        'sugerencias' => $sugerencias,
        'historial'   => array_map(fn($r) => [
            'nro'      => $r->nro ?? $r->id,
            'cat'      => $r->categoria,
            'desc'     => mb_substr($r->descripcion, 0, 120).'…',
            'sol'      => $r->observaciones ? mb_substr($r->observaciones, 0, 200) : null,
            'tecnico'  => $r->tecnico,
            'fecha'    => $r->fecha_atencion,
        ], $historial),
    ];
}
