<?php
function rep_list(PDO $pdo, array $f = []): array {
    $w = ['1=1']; $p = [];
    if (!empty($f['estado']))    { $w[] = 'estado=?';    $p[] = $f['estado']; }
    if (!empty($f['prioridad'])) { $w[] = 'prioridad=?'; $p[] = $f['prioridad']; }
    if (!empty($f['categoria'])) { $w[] = 'categoria=?'; $p[] = $f['categoria']; }
    if (!empty($f['tecnico']))   { $w[] = 'tecnico=?';   $p[] = $f['tecnico']; }
    if (!empty($f['mes']))       { $w[] = 'MONTH(fecha_atencion)=?'; $p[] = (int)$f['mes']; }
    if (!empty($f['anio']))      { $w[] = 'YEAR(fecha_atencion)=?';  $p[] = (int)$f['anio']; }
    if (!empty($f['q'])) {
        $w[] = '(descripcion LIKE ? OR contacto LIKE ? OR observaciones LIKE ? OR categoria LIKE ?)';
        $like = '%'.$f['q'].'%';
        array_push($p, $like, $like, $like, $like);
    }
    $sql = 'SELECT * FROM st_reportes WHERE '.implode(' AND ',$w).' ORDER BY creado DESC';
    $st = $pdo->prepare($sql); $st->execute($p);
    return $st->fetchAll();
}

function rep_get(PDO $pdo, int $id): ?object {
    $st = $pdo->prepare('SELECT * FROM st_reportes WHERE id=?');
    $st->execute([$id]);
    return $st->fetch() ?: null;
}

function rep_save(PDO $pdo, array $d, int $id = 0): int {
    $cols = ['fecha_atencion','hora_inicio','hora_fin','tipo_atencion','oficina','area',
             'contacto','tecnico','medio','estado','categoria','prioridad',
             'descripcion','observaciones','tiempo_invertido','satisfaccion'];
    $data = [];
    foreach ($cols as $c) $data[$c] = isset($d[$c]) ? trim($d[$c]) : null;
    if (empty($data['fecha_atencion'])) $data['fecha_atencion'] = date('Y-m-d');

    if ($id > 0) {
        $set = implode(',', array_map(fn($c) => "$c=?", array_keys($data)));
        $st = $pdo->prepare("UPDATE st_reportes SET $set WHERE id=?");
        $st->execute([...array_values($data), $id]);
        return $id;
    } else {
        $cols_str = implode(',', array_keys($data));
        $ph = implode(',', array_fill(0, count($data), '?'));
        $st = $pdo->prepare("INSERT INTO st_reportes ($cols_str) VALUES ($ph)");
        $st->execute(array_values($data));
        return (int)$pdo->lastInsertId();
    }
}

function rep_delete(PDO $pdo, int $id): void {
    $pdo->prepare('DELETE FROM st_reportes WHERE id=?')->execute([$id]);
}

function rep_dashboard(PDO $pdo, int $mes, int $anio): array {
    $base = 'FROM st_reportes WHERE MONTH(fecha_atencion)=? AND YEAR(fecha_atencion)=?';
    $p = [$mes, $anio];
    $q = fn($sql) => $pdo->prepare($sql)->execute($p) ? null : null;

    $s = fn($sql) => (function() use ($pdo,$sql,$p) { $st=$pdo->prepare($sql);$st->execute($p);return $st; });

    $get = function($sql) use ($pdo, $p) {
        $st = $pdo->prepare($sql); $st->execute($p); return $st->fetchColumn();
    };
    $all = function($sql) use ($pdo, $p) {
        $st = $pdo->prepare($sql); $st->execute($p); return $st->fetchAll();
    };

    return [
        'total'         => (int)$get("SELECT COUNT(*) $base"),
        'abiertos'      => (int)$get("SELECT COUNT(*) $base AND estado='Abierto'"),
        'en_proceso'    => (int)$get("SELECT COUNT(*) $base AND estado='En proceso'"),
        'cerrados'      => (int)$get("SELECT COUNT(*) $base AND estado='Cerrado'"),
        'alta_prio'     => (int)$get("SELECT COUNT(*) $base AND prioridad IN('Alta','Crítica')"),
        'satisfaccion'  => round((float)$get("SELECT AVG(satisfaccion) $base AND satisfaccion>0"), 1),
        'por_estado'    => $all("SELECT estado, COUNT(*) total $base GROUP BY estado"),
        'por_categoria' => $all("SELECT categoria, COUNT(*) total $base GROUP BY categoria ORDER BY total DESC LIMIT 7"),
        'por_tecnico'   => $all("SELECT tecnico, COUNT(*) total $base GROUP BY tecnico ORDER BY total DESC LIMIT 6"),
        'por_dia'       => $all("SELECT DAY(fecha_atencion) dia, COUNT(*) total $base GROUP BY dia ORDER BY dia"),
        'por_prioridad' => $all("SELECT prioridad, COUNT(*) total $base GROUP BY prioridad"),
    ];
}

function rep_buscar_cerrados(PDO $pdo, string $q): array {
    $like = '%'.$q.'%';
    $st = $pdo->prepare(
        "SELECT id,nro,categoria,descripcion,observaciones,tecnico,fecha_atencion
         FROM st_reportes WHERE estado='Cerrado'
         AND (descripcion LIKE ? OR observaciones LIKE ? OR categoria LIKE ?)
         ORDER BY fecha_atencion DESC LIMIT 12"
    );
    $st->execute([$like,$like,$like]);
    return $st->fetchAll();
}
