/* Sistema Soporte Técnico — Vanilla JS */
(function(){
'use strict';

// ─── CONFIG ──────────────────────────────────────────────
var API = 'api.php';
var charts = {};
var modalId = 0;

// ─── UTILS ───────────────────────────────────────────────
function $(s,c){ return (c||document).querySelector(s); }
function $$(s,c){ return (c||document).querySelectorAll(s); }
function on(el,ev,fn){ if(el) el.addEventListener(ev,fn); }

function post(action, data, cb){
  var fd = new FormData();
  fd.append('action', action);
  fd.append('_csrf', CSRF);
  for(var k in data) fd.append(k, data[k]??'');
  fetch(API, {method:'POST', body:fd})
    .then(function(r){ return r.json(); })
    .then(function(r){
      if(r.ok) cb(null, r.data);
      else cb(r.msg || 'Error.', null);
    })
    .catch(function(){ cb('Error de conexión.', null); });
}

function toast(msg, type){
  var d = document.createElement('div');
  d.className = 'alert '+(type||'ok');
  d.style.cssText = 'position:fixed;bottom:20px;right:20px;z-index:9999;max-width:340px;box-shadow:0 8px 24px rgba(0,0,0,.4)';
  d.textContent = msg;
  document.body.appendChild(d);
  setTimeout(function(){ d.style.opacity='0'; d.style.transition='opacity .4s';
    setTimeout(function(){ d.remove(); }, 400); }, 3000);
}

function badge(val, map){
  var cls = map[val] || 'bg';
  return '<span class="b '+cls+'">'+(val||'—')+'</span>';
}
function bEst(v){ return badge(v,{Abierto:'bb','En proceso':'bo',Pendiente:'bg',Cerrado:'bgr'}); }
function bPri(v){ return badge(v,{Baja:'bgr',Media:'bb',Alta:'bo','Crítica':'br'}); }
function esc(s){ var d=document.createElement('div');d.textContent=s||'';return d.innerHTML; }

// ─── NAVEGACIÓN ──────────────────────────────────────────
var VIEWS = {
  dashboard: 'Dashboard', lista: 'Registros', nuevo: 'Nuevo Reporte',
  buscar: 'Buscar Soluciones', ia: 'Asistente IA'
};

function show(v){
  $$('.view').forEach(function(el){ el.classList.remove('active'); });
  $$('.nav').forEach(function(el){ el.classList.remove('active'); });
  var el = $('#v-'+v);
  if(el) el.classList.add('active');
  var nav = $('[data-v="'+v+'"]');
  if(nav) nav.classList.add('active');
  var bc = $('#breadcrumb');
  if(bc) bc.textContent = VIEWS[v]||v;
  $('#sidebar').classList.remove('open');
  if(v==='dashboard') loadDash();
  if(v==='lista') loadLista({});
  if(v==='nuevo' && !$('#r-id').value*1) resetForm();
}

on(document,'click',function(e){
  var el = e.target.closest('[data-v]');
  if(el){ e.preventDefault(); show(el.dataset.v); }
});

// Mobile sidebar
on($('#menu-toggle'),'click',function(){ $('#sidebar').classList.toggle('open'); });

// ─── SESSION TIMER ────────────────────────────────────────
function startTimer(){
  function tick(){
    var left = SESSION_EXP - Math.floor(Date.now()/1000);
    if(left<=0){ location.reload(); return; }
    var m=Math.floor(left/60), s=left%60;
    var el = $('#timer');
    if(el){
      el.textContent=(m<10?'0':'')+m+':'+(s<10?'0':'')+s;
      el.style.color = left<120 ? '#EF4444' : '';
    }
  }
  tick();
  setInterval(tick,1000);
}

// ─── LOGIN ────────────────────────────────────────────────
var btnLogin = $('#btn-login');
if(btnLogin){
  on(btnLogin,'click',function(){
    var u=$('#u').value.trim(), p=$('#p').value;
    if(!u||!p){ showErr('Completa todos los campos.'); return; }
    btnLogin.innerHTML='<span class="spin"></span> Ingresando...';
    btnLogin.disabled=true;
    post('login',{username:u,password:p},function(err){
      if(err){ showErr(err); btnLogin.textContent='Ingresar al sistema'; btnLogin.disabled=false; }
      else location.reload();
    });
  });
  on($('#p'),'keypress',function(e){ if(e.key==='Enter') btnLogin.click(); });
  on($('#u'),'keypress',function(e){ if(e.key==='Enter') $('#p').focus(); });
}
function showErr(m){
  var el=$('#login-err');
  if(el){ el.textContent=m; el.style.display='block'; }
}

// LOGOUT
on($('#btn-logout'),'click',function(){
  post('logout',{},function(){ location.reload(); });
});

// ─── DASHBOARD ────────────────────────────────────────────
function loadDash(){
  var mes=$('#d-mes').value, anio=$('#d-anio').value;
  post('dashboard',{mes:mes,anio:anio},function(err,d){
    if(err) return;
    $('#k-total').textContent = d.total;
    $('#k-ab').textContent    = d.abiertos;
    $('#k-ep').textContent    = d.en_proceso;
    $('#k-cl').textContent    = d.cerrados;
    $('#k-alta').textContent  = d.alta_prio;
    $('#k-sat').textContent   = d.satisfaccion>0 ? d.satisfaccion+'/5' : '—';
    renderCharts(d);
  });
}
on($('#d-refresh'),'click',loadDash);

function renderCharts(d){
  Chart.defaults.color='#64748B';
  Chart.defaults.borderColor='#1E2D45';
  var def={responsive:true,maintainAspectRatio:false,plugins:{legend:{display:false}}};

  // Días
  var dias = d.por_dia||[];
  bar('ch-dias', dias.map(function(x){return 'D'+x.dia;}),
                  dias.map(function(x){return x.total;}), '#38BDF8', def);

  // Categorías
  var cats = d.por_categoria||[];
  bar('ch-cats', cats.map(function(x){return x.categoria||'?';}),
                  cats.map(function(x){return x.total;}), '#8B5CF6', def);

  // Estado doughnut
  var est = d.por_estado||[];
  var colors=['#38BDF8','#F59E0B','#10B981','#64748B','#EF4444'];
  if(charts['estado']) charts['estado'].destroy();
  charts['estado'] = new Chart(document.getElementById('ch-estado'),{
    type:'doughnut',
    data:{labels:est.map(function(x){return x.estado||'?';}),
          datasets:[{data:est.map(function(x){return x.total;}),backgroundColor:colors,borderWidth:0,hoverOffset:6}]},
    options:Object.assign({},def,{plugins:{legend:{display:true,position:'bottom',labels:{color:'#94A3B8',boxWidth:10,padding:10}}}})
  });

  // Top técnicos
  var tecs=d.por_tecnico||[];
  var tt=$('#top-tec');
  if(!tt) return;
  var maxT = Math.max.apply(null,tecs.map(function(t){return+t.total;})||[1]);
  tt.innerHTML = tecs.length ? tecs.map(function(t){
    var pct = maxT>0 ? (t.total/maxT*100) : 0;
    return '<div class="rank-item">'+
      '<span class="rname">'+(t.tecnico||'?').substring(0,14)+'</span>'+
      '<div class="rbar-w"><div class="rbar" style="width:'+pct+'%"></div></div>'+
      '<span class="rcount">'+t.total+'</span></div>';
  }).join('') : '<div class="empty"><span>📊</span>Sin datos este mes</div>';
}

function bar(id, labels, data, color, def){
  if(charts[id]) charts[id].destroy();
  var el=document.getElementById(id);
  if(!el) return;
  charts[id]=new Chart(el,{
    type:'bar',
    data:{labels:labels,datasets:[{data:data,backgroundColor:color+'30',borderColor:color,borderWidth:2,borderRadius:4}]},
    options:Object.assign(true,{},def,{scales:{x:{ticks:{color:'#64748B',font:{size:10}}},y:{beginAtZero:true,ticks:{stepSize:1,color:'#64748B'}}}})
  });
}

// ─── LISTA ───────────────────────────────────────────────
function loadLista(f){
  var tb=$('#tbody'); if(!tb) return;
  tb.innerHTML='<tr><td colspan="8" class="tc"><span class="spin"></span> Cargando...</td></tr>';
  post('reportes',f,function(err,rows){
    if(err){ tb.innerHTML='<tr><td colspan="8" class="tc">Error al cargar.</td></tr>'; return; }
    if(!rows||!rows.length){
      tb.innerHTML='<tr><td colspan="8"><div class="empty"><span>📋</span>Sin registros con estos filtros.</div></td></tr>';
      return;
    }
    tb.innerHTML = rows.map(function(r){
      return '<tr>'+
        '<td class="mono">#'+(r.nro||r.id)+'</td>'+
        '<td>'+(r.fecha_atencion||'—')+'</td>'+
        '<td style="max-width:130px;overflow:hidden;text-overflow:ellipsis;white-space:nowrap">'+esc(r.contacto||'—')+'</td>'+
        '<td>'+(r.categoria?'<span class="b bp">'+esc(r.categoria)+'</span>':'—')+'</td>'+
        '<td>'+esc(r.tecnico||'—')+'</td>'+
        '<td>'+bPri(r.prioridad)+'</td>'+
        '<td>'+bEst(r.estado)+'</td>'+
        '<td>'+
          '<button class="ic-btn" data-ac="ver" data-id="'+r.id+'">👁️</button> '+
          '<button class="ic-btn" data-ac="ed" data-id="'+r.id+'">✏️</button>'+
          (IS_ADMIN ? ' <button class="ic-btn" data-ac="del" data-id="'+r.id+'">🗑️</button>' : '')+
        '</td>'+
      '</tr>';
    }).join('');
  });
}

on($('#btn-filtrar'),'click',function(){
  loadLista({q:$('#f-q').value,estado:$('#f-est').value,prioridad:$('#f-pri').value,categoria:$('#f-cat').value});
});
on($('#btn-limpiar'),'click',function(){
  $$('#f-q,#f-est,#f-pri,#f-cat').forEach(function(e){e.value='';});
  loadLista({});
});

on(document,'click',function(e){
  var btn=e.target.closest('[data-ac]');
  if(!btn) return;
  var ac=btn.dataset.ac, id=btn.dataset.id;
  if(ac==='ver')  verReporte(id);
  if(ac==='ed')   editReporte(id);
  if(ac==='del')  delReporte(id);
});

// ─── VER DETALLE ─────────────────────────────────────────
function verReporte(id){
  modalId=id;
  post('reporte_get',{id:id},function(err,r){
    if(err) return toast(err,'err');
    var b=$('#modal-b'); if(!b) return;
    b.innerHTML='<div class="dg">'+
      di('#Req',r.nro||r.id)+di('Fecha',r.fecha_atencion)+
      di('Hora inicio',r.hora_inicio)+di('Hora fin',r.hora_fin)+
      di('Tipo',r.tipo_atencion)+di('Medio',r.medio)+
      di('Contacto',r.contacto)+di('Técnico',r.tecnico)+
      di('Oficina',r.oficina)+di('Área',r.area)+
      di('Categoría',r.categoria)+
      '<div class="di"><label>Prioridad</label><div class="dv">'+bPri(r.prioridad)+'</div></div>'+
      '<div class="di"><label>Estado</label><div class="dv">'+bEst(r.estado)+'</div></div>'+
      di('Tiempo',r.tiempo_invertido)+
      di('Satisfacción',r.satisfaccion>0?'⭐'.repeat(+r.satisfaccion):'No evaluado')+
      '<div class="di d-full"><label>Descripción</label><div class="d-box">'+esc(r.descripcion)+'</div></div>'+
      '<div class="di d-full"><label>Solución / Observaciones</label><div class="d-box">'+esc(r.observaciones||'—')+'</div></div>'+
    '</div>';
    $('#modal-t').textContent='Reporte #'+(r.nro||r.id);
    $('#modal').style.display='flex';
  });
}
function di(l,v){ return '<div class="di"><label>'+l+'</label><div class="dv">'+esc(v||'—')+'</div></div>'; }

on($('#modal-cl'),'click',function(){ $('#modal').style.display='none'; });
on($('#modal-cl2'),'click',function(){ $('#modal').style.display='none'; });
on($('#modal-edit'),'click',function(){ $('#modal').style.display='none'; editReporte(modalId); });
on($('#modal'),'click',function(e){ if(e.target===$('#modal')) $('#modal').style.display='none'; });

// ─── EDITAR ──────────────────────────────────────────────
function editReporte(id){
  post('reporte_get',{id:id},function(err,r){
    if(err) return toast(err,'err');
    $('#r-id').value=r.id;
    $('#r-fecha').value=r.fecha_atencion||'';
    $('#r-hini').value=r.hora_inicio||'';
    $('#r-hfin').value=r.hora_fin||'';
    $('#r-tipo').value=r.tipo_atencion||'Presencial';
    $('#r-medio').value=r.medio||'WhatsApp';
    $('#r-tiempo').value=r.tiempo_invertido||'';
    $('#r-ofic').value=r.oficina||'';
    $('#r-area').value=r.area||'';
    $('#r-cont').value=r.contacto||'';
    $('#r-tec').value=r.tecnico||'';
    $('#r-sat').value=r.satisfaccion||0;
    $('#r-cat').value=r.categoria||'';
    $('#r-pri').value=r.prioridad||'Media';
    $('#r-est').value=r.estado||'Abierto';
    $('#r-desc').value=r.descripcion||'';
    $('#r-obs').value=r.observaciones||'';
    $('#form-h').textContent='Editar Reporte #'+(r.nro||r.id);
    show('nuevo');
  });
}

// ─── ELIMINAR ────────────────────────────────────────────
function delReporte(id){
  if(!confirm('¿Eliminar este reporte? No se puede deshacer.')) return;
  post('reporte_delete',{id:id},function(err){
    if(err) return toast(err,'err');
    toast('Reporte eliminado.');
    loadLista({});
  });
}

// ─── GUARDAR ─────────────────────────────────────────────
on($('#rep-form'),'submit',function(e){
  e.preventDefault();
  var btn=$('#btn-save');
  btn.innerHTML='<span class="spin"></span> Guardando...';
  btn.disabled=true;
  post('reporte_save',{
    id:$('#r-id').value,
    fecha_atencion:$('#r-fecha').value,
    hora_inicio:$('#r-hini').value, hora_fin:$('#r-hfin').value,
    tipo_atencion:$('#r-tipo').value, medio:$('#r-medio').value,
    tiempo_invertido:$('#r-tiempo').value,
    oficina:$('#r-ofic').value, area:$('#r-area').value,
    contacto:$('#r-cont').value, tecnico:$('#r-tec').value,
    satisfaccion:$('#r-sat').value, categoria:$('#r-cat').value,
    prioridad:$('#r-pri').value, estado:$('#r-est').value,
    descripcion:$('#r-desc').value, observaciones:$('#r-obs').value,
  },function(err,res){
    btn.textContent='💾 Guardar reporte'; btn.disabled=false;
    if(err) return toast(err,'err');
    toast(res.msg);
    show('lista');
  });
});

function resetForm(){
  if($('#r-id')) $('#r-id').value=0;
  var f=$('#rep-form'); if(f) f.reset();
  if($('#form-h')) $('#form-h').textContent='Nuevo Reporte';
  var fd=$('#r-fecha'); if(fd) fd.value=new Date().toISOString().slice(0,10);
  var ib=$('#ia-form-res'); if(ib) ib.style.display='none';
}

// ─── IA INLINE ───────────────────────────────────────────
on($('#btn-ia-form'),'click',function(){
  var desc=$('#r-desc').value.trim();
  if(!desc){ toast('Escribe la descripción primero.','err'); return; }
  var btn=$('#btn-ia-form');
  btn.textContent='⏳ Analizando...'; btn.disabled=true;
  post('ia',{desc:desc,cat:$('#r-cat').value,prio:$('#r-pri').value},function(err,d){
    btn.textContent='🤖 Obtener sugerencias IA'; btn.disabled=false;
    if(err||!d||!d.sugerencias||!d.sugerencias.length){
      var ib=$('#ia-form-res');
      ib.innerHTML='<p style="color:#64748B;font-size:.82rem">Sin sugerencias para este caso. Intenta con más detalles.</p>';
      ib.style.display='block'; return;
    }
    var s=d.sugerencias[0];
    var h='<div style="font-size:.78rem;font-weight:700;text-transform:uppercase;letter-spacing:.05em;color:#64748B;margin-bottom:8px">🤖 Sugerencia IA</div>'+
      '<div style="font-weight:700;color:#E2E8F0;font-size:.88rem;margin-bottom:8px">'+esc(s.titulo)+'</div>'+
      '<ol style="padding-left:16px;font-size:.8rem;color:#94A3B8;line-height:1.8">';
    s.pasos.forEach(function(p){ h+='<li>'+esc(p)+'</li>'; });
    h+='</ol><div style="margin-top:8px;font-size:.76rem;color:#64748B">⏱️ '+esc(s.tiempo)+'</div>';
    var ib=$('#ia-form-res');
    ib.innerHTML=h; ib.style.display='block';
  });
});

// ─── BUSCAR SOLUCIONES ────────────────────────────────────
on($('#btn-buscar'),'click',buscar);
on($('#busq-inp'),'keypress',function(e){ if(e.key==='Enter') buscar(); });

function buscar(){
  var q=$('#busq-inp').value.trim();
  if(!q) return;
  var res=$('#busq-res');
  res.innerHTML='<div class="empty"><span class="spin"></span> Buscando...</div>';
  post('buscar',{q:q},function(err,rows){
    if(!rows||!rows.length){
      res.innerHTML='<div class="empty"><span>🔍</span>Sin resultados en la base de conocimiento.<br>Prueba el Asistente IA para sugerencias.</div>';
      return;
    }
    res.innerHTML=rows.map(function(r){
      return '<div class="res-card">'+
        '<div class="res-h">'+
          '<span class="res-num">#'+(r.nro||r.id)+'</span>'+
          (r.categoria?'<span class="b bp">'+esc(r.categoria)+'</span>':'')+
          '<span style="margin-left:auto;font-size:.75rem;color:#64748B">'+esc(r.fecha_atencion)+'</span>'+
        '</div>'+
        '<div style="font-size:.85rem;color:#94A3B8;margin-bottom:4px">'+esc(r.descripcion)+'</div>'+
        (r.observaciones?'<div class="sol-box">✅ '+esc(r.observaciones)+'</div>':'')+
        '<div class="res-meta"><span>👤 '+esc(r.tecnico)+'</span></div>'+
      '</div>';
    }).join('');
  });
}

// ─── ASISTENTE IA ─────────────────────────────────────────
on($('#btn-ia'),'click',function(){
  var desc=$('#ia-desc').value.trim();
  if(!desc){ toast('Describe el problema primero.','err'); return; }
  var btn=$('#btn-ia'), res=$('#ia-res');
  btn.innerHTML='<span class="spin"></span> Analizando...'; btn.disabled=true;
  res.innerHTML='<div class="empty"><span class="spin"></span></div>';
  post('ia',{desc:desc,cat:$('#ia-cat').value,prio:$('#ia-prio').value},function(err,d){
    btn.textContent='🔍 Analizar y obtener sugerencias'; btn.disabled=false;
    if(err||!d){ res.innerHTML=''; toast(err||'Error','err'); return; }
    renderIA(d, res);
  });
});

function renderIA(d, el){
  var h='';
  if(d.sugerencias&&d.sugerencias.length){
    h+='<div style="font-size:.75rem;font-weight:700;text-transform:uppercase;letter-spacing:.06em;color:#64748B;margin-bottom:10px">🤖 Procedimientos sugeridos</div>';
    d.sugerencias.forEach(function(s){
      var pc=(s.prio_sug||'').toLowerCase();
      h+='<div class="ia-sug '+pc+'">'+
        '<div class="ia-t">'+
          '<span class="ia-conf conf-'+(s.confianza==='Alta'?'alta':'media')+'">'+
            (s.confianza==='Alta'?'🎯':'💡')+' '+esc(s.confianza)+
          '</span> '+esc(s.titulo)+
        '</div>'+
        '<ol class="ia-steps">';
      s.pasos.forEach(function(p,i){ h+='<li data-n="'+(i+1)+'">'+esc(p)+'</li>'; });
      h+='</ol>'+
        '<div class="ia-meta">'+
          '<span>⏱️ '+esc(s.tiempo)+'</span>'+
          '<span>📁 '+esc(s.categoria)+'</span>'+
          '<span>⚡ Prioridad sugerida: '+esc(s.prio_sug)+'</span>'+
        '</div>'+
      '</div>';
    });
  }
  if(d.historial&&d.historial.length){
    h+='<div style="font-size:.75rem;font-weight:700;text-transform:uppercase;letter-spacing:.06em;color:#64748B;margin:14px 0 8px">📂 Casos resueltos similares</div>';
    d.historial.forEach(function(c){
      h+='<div class="hist-card">'+
        '<div class="hist-h">Caso #'+(c.nro||c.id)+' — '+esc(c.cat)+'</div>'+
        '<div style="font-size:.82rem;color:#94A3B8">'+esc(c.desc)+'</div>'+
        (c.sol?'<div class="sol-box">✅ '+esc(c.sol)+'</div>':'')+
        '<div class="res-meta"><span>👤 '+esc(c.tecnico)+'</span><span>📅 '+esc(c.fecha)+'</span></div>'+
      '</div>';
    });
  }
  if(!h) h='<div class="empty"><span>🤔</span>Sin sugerencias. Agrega más detalle a la descripción.</div>';
  el.innerHTML=h;
}

// ─── INIT ─────────────────────────────────────────────────
if(LOGGED){
  // Cargar Chart.js
  var s=document.createElement('script');
  s.src='https://cdnjs.cloudflare.com/ajax/libs/Chart.js/4.4.0/chart.umd.min.js';
  s.onload=function(){
    show('dashboard');
    startTimer();
  };
  document.head.appendChild(s);
  // Fecha default
  var fd=$('#r-fecha'); if(fd) fd.value=new Date().toISOString().slice(0,10);
}

})();
