<?php
function auth_check() {
    if (!isset($_SESSION['user_id'], $_SESSION['exp'])) return false;
    if (time() > $_SESSION['exp']) { session_destroy(); return false; }
    return true;
}
function auth_require() {
    if (!auth_check()) { header('Location: index.php'); exit; }
}
function auth_user() {
    return $_SESSION['user'] ?? null;
}
function is_admin() {
    return (auth_user()['rol'] ?? '') === 'admin';
}
function auth_login(PDO $pdo, string $username, string $password): array {
    $st = $pdo->prepare("SELECT * FROM st_usuarios WHERE username=? AND activo=1");
    $st->execute([trim($username)]);
    $u = $st->fetch();
    if (!$u)                             return ['ok'=>false,'msg'=>'Usuario no encontrado.'];
    if (!password_verify($password, $u->password)) return ['ok'=>false,'msg'=>'Contraseña incorrecta.'];
    $dur = SESSION_MINUTES * 60;
    $_SESSION['user_id'] = $u->id;
    $_SESSION['exp']     = time() + $dur;
    $_SESSION['user']    = ['id'=>$u->id,'username'=>$u->username,'nombre'=>$u->nombre,'rol'=>$u->rol];
    return ['ok'=>true,'user'=>$_SESSION['user'],'exp'=>$_SESSION['exp']];
}
function auth_logout() { session_destroy(); }
