<?php
// Corre este archivo UNA SOLA VEZ para crear las tablas
// Accede a: tudominio.com/soporte/instalar.php
// BÓRRALO o renómbralo después de instalarlo

require_once 'config.php';

$sql = "
CREATE TABLE IF NOT EXISTS st_usuarios (
    id         INT AUTO_INCREMENT PRIMARY KEY,
    username   VARCHAR(80)  NOT NULL UNIQUE,
    password   VARCHAR(255) NOT NULL,
    nombre     VARCHAR(150),
    rol        ENUM('admin','tecnico') DEFAULT 'tecnico',
    activo     TINYINT(1) DEFAULT 1,
    creado     DATETIME DEFAULT CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

CREATE TABLE IF NOT EXISTS st_reportes (
    id               INT AUTO_INCREMENT PRIMARY KEY,
    nro              INT UNIQUE,
    fecha_atencion   DATE NOT NULL,
    hora_inicio      TIME,
    hora_fin         TIME,
    tipo_atencion    VARCHAR(60),
    oficina          VARCHAR(120),
    area             VARCHAR(120),
    contacto         VARCHAR(160),
    tecnico          VARCHAR(160),
    medio            VARCHAR(80),
    estado           ENUM('Abierto','En proceso','Pendiente','Cerrado') DEFAULT 'Abierto',
    categoria        VARCHAR(100),
    prioridad        ENUM('Baja','Media','Alta','Crítica') DEFAULT 'Media',
    descripcion      TEXT,
    observaciones    TEXT,
    tiempo_invertido VARCHAR(20),
    satisfaccion     TINYINT DEFAULT 0,
    creado           DATETIME DEFAULT CURRENT_TIMESTAMP,
    actualizado      DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Trigger para número de requerimiento autoincremental independiente
DROP TRIGGER IF EXISTS st_nro_auto;
";

// Ejecutar por partes
foreach (explode(';', $sql) as $q) {
    $q = trim($q);
    if ($q) $pdo->exec($q);
}

// Trigger por separado
$pdo->exec("
CREATE TRIGGER st_nro_auto BEFORE INSERT ON st_reportes
FOR EACH ROW BEGIN
    DECLARE maxnro INT;
    SELECT IFNULL(MAX(nro), 0) + 1 INTO maxnro FROM st_reportes;
    SET NEW.nro = maxnro;
END
");

// Admin por defecto
$exists = $pdo->query("SELECT COUNT(*) FROM st_usuarios WHERE username='admin'")->fetchColumn();
if (!$exists) {
    $hash = password_hash('admin123', PASSWORD_DEFAULT);
    $pdo->prepare("INSERT INTO st_usuarios (username,password,nombre,rol) VALUES ('admin',?,'Administrador','admin')")->execute([$hash]);
}

echo '<div style="font-family:monospace;padding:40px;background:#0f172a;color:#4ade80;border-radius:12px;max-width:500px;margin:60px auto;text-align:center">
    <div style="font-size:2rem;margin-bottom:16px">✅</div>
    <b style="font-size:1.1rem">Instalación completada</b><br><br>
    Tablas creadas correctamente.<br><br>
    <b>Usuario:</b> admin<br>
    <b>Contraseña:</b> admin123<br><br>
    <span style="color:#f87171">⚠️ Elimina este archivo (instalar.php) ahora.</span><br><br>
    <a href="index.php" style="color:#38bdf8">→ Ir al sistema</a>
</div>';
